function H = SINGLES (prediction, observations, compatibility)
%-------------------------------------------------------
% University of Zaragoza
% Centro Politecnico Superior
% Robotics and Real Time Group
% Authors:  J. Neira, J. Tardos
% Date   :  7-2006
%-------------------------------------------------------
%-------------------------------------------------------
global chi2;
global configuration;

H = zeros(1, observations.m);

for i = 1:observations.m,
    flag = 0;
    for j = 1:prediction.n,
        if(compatibility.ic(i,j) == 1)
            flag = flag + 1; 
            if(flag <= 1)
                H(i) = j;
            else
                H(i) = 0;
            end
        end
    end    
end


% You have observations.m observations, and prediction.n
% predicted features.
%
% For every observation i, check whether it has only one neighbour,
% feature, and whether that feature j  has only that one neighbour
% observation i.  If so, H(i) = j.
%
% You will need to check the compatibility.ic matrix
% for this:
%
% compatibility.ic(i,j) = 1 if observation i is a neighbour of
% feature j.

            
configuration.name = 'SINGLES';
